/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.mock;

import java.util.List;
import java.util.Random;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.Date;
import pt.caf_pbs.schooldiskapi.model.Enroll;
import pt.caf_pbs.schooldiskapi.model.EnrollContainer;
import pt.caf_pbs.schooldiskapi.model.Instructor;
import pt.caf_pbs.schooldiskapi.model.InstructorContainer;
import pt.caf_pbs.schooldiskapi.model.Lecture;
import pt.caf_pbs.schooldiskapi.model.LectureContainer;
import pt.caf_pbs.schooldiskapi.model.School;
import pt.caf_pbs.schooldiskapi.model.Student;
import pt.caf_pbs.schooldiskapi.model.StudentContainer;
import pt.caf_pbs.schooldiskapi.model.Subject;
import pt.caf_pbs.schooldiskapi.model.SubjectContainer;

public class MockData {
    private int ENROLLS_NR = 5;
    private int LECTURES_NR = 5;
    private String[] name_profs = new String[]{"Abrilina D\u00e9cima Nona Ca\u00e7apavana Piratininga de Almeida", "Acheropita Papazone", "Adalgamir Marge", "Adegesto Pataca", "Adora\u00e7\u00e3o Arabites", "Aeronauta Barata", "Agr\u00edcola Beterraba Areia", "Agr\u00edcola da Terra Fonseca", "Alce Barbuda", "Aldegunda Carames More", "Aleluia Sarango", "Alfredo Prazeirozo Texugueiro", "Alma de Vera", "Amado Amoroso", "Am\u00e1vel Pinto", "Amazonas Rio do Brasil Pimp\u00e3o", "Am\u00e9rica do Sul Brasil de Santana", "Amin Amou Amado", "Amor de Deus Rosales Brasil", "Anatalino Reguete", "Ant\u00f4nio Americano do Brasil Mineiro", "Antonio Buceta Agudim", "Antonio Camis\u00e3o", "Antonio Dod\u00f3i", "Antonio Manso Pac\u00edfico de Oliveira Sossegado", "Antonio Melhoran\u00e7a", "Ant\u00f4nio Morrendo das Dores", "Antonio Noites e Dias", "Ant\u00f4nio P. Testa", "Antonio Pechincha", "Ant\u00f4nio Querido Fracasso", "Antonio Treze de Junho de Mil Novecentos e Dezessete", "Ant\u00f4nio Veado Prematuro", "Apurin\u00e3 da Floresta Brasileira", "Araci do Precioso Sangue", "Argentino Argenta", "Aricl\u00e9ia Caf\u00e9 Ch\u00e1", "Armando Nascimento de Jesus", "Arquitecl\u00ednio Petrocoqu\u00ednio de Andrade", "Aster\u00f3ide Silverio", "Ava Gina", "Banan\u00e9ia Oliveira de Deus", "Bandeirante do Brasil Paulistano", "Barrigudinha Seleida", "Bende Sande Branquinho Maracaj\u00e1", "Benedito Autor da Purifica\u00e7\u00e3o", "Benedito Camur\u00e7a Aveludado", "Benedito Fr\u00f4scolo Jovino de Almeida Aimbar\u00e9 Milit\u00e3o de Souza", "Baruel de Itaparica Bor\u00e9 Fomi de Tucunduv\u00e1", "Benigna Jarra"};
    private String[] initial_profs = new String[]{"ADNA", "AAPP", "ARME", "AOPC", "AOAS", "AABA", "ABAA", "ATFA", "AEBA", "ACME", "AASO", "APTO", "AAVA", "AOAO", "ALPO", "ARBP", "ASBS", "AAAO", "ADRB", "AORE", "AABM", "ABAM", "AOCO", "AODI", "AMPS", "AMRA", "AMDS", "ANDS", "APTA", "AOPA", "AQFO", "AMND", "AVPO", "AFBA", "APSE", "AOAA", "ACCA", "ANJS", "APAE", "AESO", "AAGA", "BODS", "BBPO", "BASA", "BSBM", "BAPO", "BCAO", "BFJA", "BIBT", "BAJA"};
    private String[] name_students = new String[]{"Benvindo Viola", "Bispo de Paris", "Bizarro Assada", "Boaventura Torrada", "Bom Filho Persegonha", "Brandamente Brasil", "Brasil Washington C. A. J\u00fanior", "Br\u00edgida de Samora Mora", "Belderagas Piru\u00e9gas de", "Alfim Cerqueira Borges Cabral", "Bucetildes", "Cafiaspirina Cruz", "Capote Valente e Marimbondo da Trindade", "Caius Marcius Africanus", "Carabino Tiro Certo", "Carlos Alberto Sant\u00edssimo Sacramento", "Cantinho da Vila Alencar da Corte Real Sampaio", "Carneiro de Souza e Faro", "Caso Raro Yamada", "C\u00e9u Azul do Sol Poente", "Chananeco Vargas da Silva", "Chevrolet da Silva Ford", "Cincero do Nascimento", "Cinconegue Washington Matos", "Clarisbadeu Braz da Silva", "Colapso Card\u00edaco da Silva", "Comigo \u00e9 Nove na Garrucha Trouxada", "Confessoura Dornelles", "Crisoprasso Compasso", "Dan\u00fabio Tarada Duarte", "Esdras Esdron Eustaquio Obirapitanga", "Esparadrapo Clemente de S\u00e1", "Espere em Deus Mateus", "Est\u00e1cio Ponta Fina Amolador", "\u00c9ter Sulf\u00farico Amazonino Rios", "Excelsa Teresinha do Menino Jesus da Costa e Silva", "Fara\u00f3 do Egito Sousa", "Fedir Lenho", "Felicidade do Lar Brasileiro", "Fin\u00f3lila Piaubilina", "Fl\u00e1vio Cavalcante Rei da Televis\u00e3o", "Francisco Not\u00f3rio Milh\u00e3o", "Francisco Zebedeu Sanguessuga", "Francisoreia Doroteia Dorida", "Fridundino Eul\u00e2mpio", "Gigle Catabriga", "Graciosa Rodela D'alho", "Heubler Janota", "Hidr\u00e1ulico Oliveira", "Himineu Casamenticio das Dores Conjugais", "Holofontina Fufucas", "Homem Bom da Cunha Souto Maior", "Horinando Pedroso Ramos", "Hugo Madeira de Lei Aroeiro", "Hypotenusa Pereira", "Ileg\u00edvel Inileg\u00edvel", "Inoc\u00eancio Coitadinho", "Isabel Defensora de Jesus", "Izabel Rainha de Portugal", "Janeiro Fevereiro de Mar\u00e7o Abril", "Jo\u00e3o Bispo de Roma", "Jo\u00e3o Cara de Jos\u00e9", "Jo\u00e3o C\u00f3lica", "Jo\u00e3o da Mesma Data", "Jo\u00e3o de Deus Fundador do Colto", "Jo\u00e3o Meias de Golveias", "Jo\u00e3o Pensa Bem", "Jo\u00e3o Sem Sobrenome", "Joaquim Pinto Molhadinho", "Jos\u00e9 Am\u00e2ncio e Seus Trinta e Nove", "Jos\u00e9 Casou de Cal\u00e7as Curtas", "Jos\u00e9 Catarrinho", "Jos\u00e9 Machuca", "Jos\u00e9 Maria Guardanapo", "Jos\u00e9 Padre Nosso", "Jos\u00e9 Teodoro Pinto Tapado", "Jos\u00e9 Xixi", "Jovelina \u00d3 Rosa Cheirosa", "Jotac\u00e1 Dois Mil e Um Juana Mula", "J\u00falio Santos P\u00e9-Curto", "Justi\u00e7a Maria de Jesus", "Lan\u00e7a Perfume Rodomet\u00e1lico de Andrade", "Le\u00e3o Rolando Pedreira", "Leda Prazeres Amante", "Letsgo Daqui (let's go)", "Liberdade Igualdade", "Fraternidade Nova York Rocha", "Libertino Africano Nobre", "Lindulfo Celidonio Calafange de Tef\u00e9", "Lynildes Carapunfada Dores F\u00edgado", "Magn\u00e9sia Bisurada do Patroc\u00ednio", "Mangan\u00eas Mangan\u00e9sfero Nacional", "Manolo Porras y Porras", "Manoel de Hora Pontual", "Manoel Sovaco de Gambar", "Manuel Sola de S\u00e1 Pato", "Manuelina Terebentina", "Capitulina de Jesus Amor Divino", "Marciano Verdinho das Antenas Longas", "Maria Constan\u00e7a Dores Pan\u00e7a", "Maria Cristina do Pinto", "Magro Maria da Cruz Rachadinho", "Maria da Segunda Distra\u00e7\u00e3o", "Maria de Seu Pereira", "Maria Felicidade", "Maria Humilde", "Maria M\u00e1quina", "Maria Panela", "Maria Passa Cantando", "Maria Privada de Jesus", "Maria Tributina Prostituta Cataerva", "Maria-voc\u00ea-me-mata", "M\u00e1rio de Seu Pereira", "Meirelaz Assun\u00e7\u00e3o", "Mijardina Pinto", "Mimar\u00e9 \u00cdndio Brazileiro de Campos", "Minist\u00e9io Salgado", "Naida Navinda Navolta Pereira", "Napole\u00e3o Estado do Pernambuco", "Napole\u00e3o Sem Medo e Sem M\u00e1cula", "Natal Carnaval", "Natanael Gosmoguete de Souza", "Necrot\u00e9rio Pereira da Silva", "Novelo Fedelo", "Oceano Atl\u00e2ntico Linhares", "Olinda Barba de Jesus", "Orlando Modesto Pinto", "Orquerio Cassapietra", "Ot\u00e1vio Bundasseca", "Pac\u00edfico Armando Guerra", "Padre Filho do Esp\u00edrito Santo Am\u00e9m", "P\u00e1lia P\u00e9lia P\u00f3lia P\u00falia dos Guimar\u00e3es Peixoto", "Paranahyba Pirapitinga Santana", "Penha Pedrinha Bonitinha da Silva"};
    private String[] name_subjects = new String[]{" \u00c1lgebra", "Algoritmia e Programa\u00e7\u00e3o", "Circuitos El\u00e9tricos e Eletr\u00f3nicos", " Matem\u00e1tica I", "Projeto de Engenharia", "Sistemas Digitais", "Arquitetura de Computadores", "Fundamentos de Desenvolvimento de Software", "Fundamentos de Telecomunica\u00e7\u00f5es", "Matem\u00e1tica II", " Microprocessadores", "Sistemas de Eletr\u00f3nica Anal\u00f3gica"};
    private String[] initial_subjects = new String[]{"ALGB", "APROG", "CIRCE", "MATE1", "PROJE", "SISDIG", "ARQCP", "FSOFT", "FTELC", "MATE2", "MCROP", "SISEA"};

    private Date genDate() {
        Random gen = new Random(System.currentTimeMillis());
        int day = 1 + gen.nextInt(Integer.MAX_VALUE) % 27;
        int month = 1 + gen.nextInt(Integer.MAX_VALUE) % 12;
        int year = 1970 + gen.nextInt(Integer.MAX_VALUE) % 40;
        Date dt = new Date(day, month, year);
        return dt;
    }

    private void insertSubjects(SubjectContainer container) {
        for (int i = 0; i < this.name_subjects.length; ++i) {
            Subject obj = new Subject(this.initial_subjects[i], this.name_subjects[i]);
            try {
                container.add(obj);
                continue;
            }
            catch (DuplicatedDataException duplicatedDataException) {
                // empty catch block
            }
        }
    }

    private void insertStudents(StudentContainer container) {
        for (int i = 0; i < this.name_students.length; ++i) {
            Date dt = this.genDate();
            Student obj = new Student(this.name_students[i], dt);
            container.add(obj);
        }
    }

    private void insertInstructors(InstructorContainer container) {
        for (int i = 0; i < this.name_profs.length; ++i) {
            Instructor obj = new Instructor(this.initial_profs[i], this.name_profs[i]);
            try {
                container.add(obj);
                continue;
            }
            catch (DuplicatedDataException duplicatedDataException) {
                // empty catch block
            }
        }
    }

    private Subject getRandomSubject(SubjectContainer subjects) {
        Random gen = new Random(System.currentTimeMillis());
        List listSubject = subjects.getAll();
        int is = gen.nextInt(Integer.MAX_VALUE) % listSubject.size();
        String initials = ((Subject)listSubject.get(is)).getInitials();
        Subject ptr = subjects.get(initials);
        return ptr;
    }

    private void insertEnrolls(StudentContainer students, SubjectContainer subjects, EnrollContainer container) {
        Random gen = new Random(System.currentTimeMillis());
        List listStudent = students.getAll();
        for (Student student : listStudent) {
            int n = 1 + gen.nextInt(Integer.MAX_VALUE) % this.ENROLLS_NR;
            for (int i = 0; i < n; ++i) {
                Subject subject = this.getRandomSubject(subjects);
                int grade = 10 + gen.nextInt(Integer.MAX_VALUE) % 11;
                try {
                    Enroll enroll = new Enroll(grade, subject, student);
                    container.add(enroll);
                    continue;
                }
                catch (DuplicatedDataException duplicatedDataException) {
                    // empty catch block
                }
            }
        }
    }

    private void insertLectures(SubjectContainer subjects, InstructorContainer instructors) {
        Random gen = new Random(System.currentTimeMillis());
        List listInstructor = instructors.getAll();
        for (Instructor instructor : listInstructor) {
            Instructor ptr = instructors.get(instructor.getInitials());
            LectureContainer container = ptr.getLectures();
            int n = 1 + gen.nextInt() % this.LECTURES_NR;
            for (int i = 0; i < n; ++i) {
                Subject subject = this.getRandomSubject(subjects);
                try {
                    Lecture lecture = new Lecture(subject);
                    container.add(lecture);
                    continue;
                }
                catch (DuplicatedDataException duplicatedDataException) {
                    // empty catch block
                }
            }
        }
    }

    public void generateData(School school) {
        this.insertSubjects(school.getSubjectContainer());
        this.insertStudents(school.getStudentContainer());
        this.insertInstructors(school.getInstructorContainer());
        this.insertEnrolls(school.getStudentContainer(), school.getSubjectContainer(), school.getEnrollContainer());
        this.insertLectures(school.getSubjectContainer(), school.getInstructorContainer());
    }
}

